---
name: Bug report
about: 'AMGX crashes, APIs return unexpected errors, etc. '
title: "[Issue]"
labels: bug
assignees: ''

---

**Describe the issue**

A clear and concise description of what the issue is.

**Environment information:**
 - OS: [e.g. `Windows 10`, `Ubuntu 22.04`]
 - CUDA runtime: [e.g. `CUDA 11.7.0`]
 - MPI version (if applicable): [e.g. `OpenMPI 4.0.3`, `MS-MPI v10.1.2`]
 - AMGX version or commit hash [e.g. `v2.3.0`, `34232979e993d349a03486f7892830a1209b2fc9`]
 - NVIDIA driver: [e.g. 517.40]
 - NVIDIA GPU: [e.g. NVIDIA V100]
 - Any related environment variables information

**AMGX solver configuration** 

If you used AMGX solver configuration to initialize a solver - provide it here.

**Matrix Data**

It would be very helpful if you can provide matrix data that reproduces the error. If you can share it (matrix, right hand side, initial solution) - describe how to get it or provide download links for this data.

**Reproduction steps** 

If your AMGX workflow differs from one of AMGX examples - provide minimal reproducible example for the reported issue

**Additional context**

Add any other context about the problem here.
