/*!
 ******************************************************************************
 *
 * \file
 *
 * \brief   RAJA header file defining SIMD/SIMT register operations.
 *
 ******************************************************************************
 */

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
// Copyright (c) 2016-25, Lawrence Livermore National Security, LLC
// and RAJA project contributors. See the RAJA/LICENSE file for details.
//
// SPDX-License-Identifier: (BSD-3-Clause)
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//

#ifndef RAJA_pattern_tensor_HPP
#define RAJA_pattern_tensor_HPP

#include "RAJA/pattern/tensor/stats.hpp"
#include "RAJA/pattern/tensor/internal/RegisterBase.hpp"
#include "RAJA/pattern/tensor/TensorIndex.hpp"
#include "RAJA/pattern/tensor/TensorRegister.hpp"

#include "RAJA/pattern/tensor/ScalarRegister.hpp"
#include "RAJA/pattern/tensor/VectorRegister.hpp"
#include "RAJA/pattern/tensor/MatrixRegister.hpp"

#include "RAJA/pattern/tensor/internal/ExpressionTemplate.hpp"
#include "RAJA/pattern/tensor/internal/MatrixRegisterImpl.hpp"
#include "RAJA/pattern/tensor/internal/VectorRegisterImpl.hpp"


#include "RAJA/pattern/tensor/TensorBlock.hpp"

#endif
