/*!
 ******************************************************************************
 *
 * \file
 *
 * \brief   Header file containing RAJA headers for sequential execution.
 *
 *          These methods work on all platforms.
 *
 ******************************************************************************
 */

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
// Copyright (c) 2016-21, Lawrence Livermore National Security, LLC
// and RAJA project contributors. See the RAJA/COPYRIGHT file for details.
//
// SPDX-License-Identifier: (BSD-3-Clause)
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//

#ifndef RAJA_sequential_HPP
#define RAJA_sequential_HPP

#include "RAJA/policy/sequential/atomic.hpp"
#include "RAJA/policy/sequential/forall.hpp"
#include "RAJA/policy/sequential/kernel.hpp"
#include "RAJA/policy/sequential/policy.hpp"
#include "RAJA/policy/sequential/reduce.hpp"
#include "RAJA/policy/sequential/scan.hpp"
#include "RAJA/policy/sequential/sort.hpp"
#include "RAJA/policy/sequential/teams.hpp"
#include "RAJA/policy/sequential/WorkGroup.hpp"

#endif  // closing endif for header file include guard
